<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use Countable;

/**
 * @template TEvent of Event
 */
interface EventStream extends Countable, Listenable
{
    /**
     * Returns an iterable result with all the events in the stream starting from a specific revision.
     *
     * The events range MUST be exclusive.
     *
     * @return iterable<int, TEvent>
     */
    public function above(int $revision): iterable;

    /**
     * Returns an iterable result with all the events in the stream.
     *
     * @return iterable<int, TEvent>
     */
    public function all(): iterable;

    /**
     * Returns current count of all the events in the stream.
     */
    public function count(): int;

    /**
     * Returns current stream revision. This MUST be equal to the current count of the events in the stream.
     */
    public function currentRevision(): int;

    /**
     * Returns TRUE if this stream does not have any events recorded yet.
     */
    public function isEmpty(): bool;

    /**
     * Returns an iterable result with all the events in the stream until reaching specific revision.
     *
     * The events range MUST be inclusive.
     *
     * @return iterable<int, TEvent>
     */
    public function until(int $revision): iterable;
}
