<?php

declare(strict_types=1);

namespace Insight\Bundle\EventSourcingBundle\Projector;

use Insight\Bundle\EventSourcingBundle\Exception\InvalidConfigurationException;
use Symfony\Component\DependencyInjection\Attribute\AutowireIterator;

final readonly class ProjectorWorkerRegistry
{
    /**
     * @var array<string, ProjectorWorker>
     */
    private array $workers;

    /**
     * @param iterable<string, ProjectorWorker> $workers
     */
    public function __construct(
        #[AutowireIterator(tag: 'es.worker', indexAttribute: 'id')] iterable $workers,
    ) {
        $this->workers = iterator_to_array($workers);
    }

    public function get(string $workerId): ProjectorWorker
    {
        return $this->workers[$workerId] ?? throw new InvalidConfigurationException("Projector worker `$workerId` not found.");
    }

    public function has(string $workerId): bool
    {
        return array_key_exists($workerId, $this->workers);
    }
}
    