<?php

declare(strict_types=1);

namespace Insight\Bundle\EventSourcingBundle\Command;

use Insight\Bundle\EventSourcingBundle\Projector\ProjectorWorkerRegistry;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\ConsoleOutput;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(
    name: 'es:projector:start',
    description: 'Start a projector worker process',
)]
final class StartProjectorCommand extends Command
{
    public function __construct(private readonly ProjectorWorkerRegistry $workers)
    {
        parent::__construct();
    }

    protected function configure(): void
    {
        $this->addArgument(
            name: 'projectorId',
            mode: InputArgument::REQUIRED,
        );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $projectorId = $input->getArgument('projectorId');

        if (!$this->workers->has($projectorId)) {
            return $this->error($output, "Unknown projector: $projectorId");
        }

        $output->writeln('Starting projector worker...');

        $this->workers->get($projectorId)->start();

        return Command::SUCCESS;
    }

    public function error(OutputInterface $output, string $message): int
    {
        $output instanceof ConsoleOutput
            ? $output->getErrorOutput()->writeln($message)
            : $output->writeln($message);

        return Command::INVALID;
    }
}
    