# EventSourcingBundle

This bundle implements EventSourcing component into Symfony to simplify configuration process.

## Installation

#### Prerequisites

* PHP 8.4 or higher
* Symfony 6.0 or higher

#### Composer

Make sure to add private package registry to your `composer.json` file:

```json
{
    "repositories": [
        { "type": "composer", "url": "https://testowy11.tere.pl/" }
    ]
}
```
Then install the package with:

```bash
composer require insight/event-sourcing-bundle
```

#### Enable the Bundle

Add the bundle to your `config/bundles.php`:

```php
return [
    // ...
    Insight\Bundle\EventSourcingBundle::class => ['all' => true],
];
```

## Configuration

The bundle does nothing until you configure it. To do so, create a configuration file `config/packages/event_sourcing.yaml`

#### Configuration reference

```yaml
event_sourcing:
    # Empty by default
    aggregates:
        - App\ExampleAggregate1 # FQCN of the aggregate class. It has to extend EventSourceAggregate class
        - App\ExampleAggregate2
        - ...

    # Empty by default
    stores: 
        some_store: # Unique store identifier
            type: mongo # One of the supported store types
            options: # Empty by default
                option1: value1 # Custom options that are defined and validated by the store factory.
                
    # Empty by default
    projectors:
        some_projector: # Unique projector identifier
            store: some_store # Store identifier on which this projector is going to listen
            projections:
                - App\ExampleView1 # Projections to run. These are Symfony service ids and therefore have to exist in the container.
                - App\ExampleView2
                - ...
```

#### Services

A bunch of services prefixed with `es.` are generated based on the configuration file. Following above example:

- `es.store.some_store` - event store
- `es.repository.some_store` - event source aggregate repository linked to the event store
- `es.projector.some_store` - projector linked to the event store
- `es.worker.some_projector` - single projector worker

If there is EXACTLY one event store configured, additional aliases are created for that store:

- `es.store.*` -> `Insight\Component\EventSourcing\EventStore`
- `es.repository.*` -> `Insight\Component\EventSourcing\EventSourceAggregateRepository`
- `es.projector.*` -> `Insight\Component\EventSourcing\Projector`

#### Store extensions

To support event store type, you need to write appropriate store extension. Every store extension has to implement `Insight\Bundle\EventSourcing\Extension\StoreExtension` interface.
Extensions are automatically discovered by bundle so no further action is required.

## Usage

#### Running projectors

In order to run projector worker, you need to run `es:projector:start {projectorId}` command.
