<?php

declare(strict_types=1);

namespace Insight\Bundle\EventSourcingBundle\Cache;

use Insight\Component\EventSourcing\EventStore;
use Symfony\Component\DependencyInjection\Attribute\AutowireIterator;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;

final readonly class EventStoreWarmer implements CacheWarmerInterface
{
    /**
     * @param iterable<int, EventStore> $stores
     */
    public function __construct(
        #[AutowireIterator('es.store')] private iterable $stores,
    ) {
    }

    public function isOptional(): bool
    {
        return false;
    }

    public function warmUp(string $cacheDir, ?string $buildDir = null): array
    {
        foreach ($this->stores as $store) {
            $store->initialize();
        }
        return [];
    }
}
