<?php

declare(strict_types=1);

use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;

return static function (DefinitionConfigurator $definition): void
{
    $definition->rootNode()
        ->children()
            ->arrayNode('stores')
                ->defaultValue([])
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('type')
                            ->isRequired()
                        ->end()
                        ->arrayNode('indexes')
                            ->defaultValue([])
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('options')
                            ->addDefaultsIfNotSet()
                            ->ignoreExtraKeys(false)
                        ->end()
                    ->end()
                ->end()
            ->end()
        ->end()
    ;
};
