<?php

declare(strict_types=1);

namespace Insight\Bundle\EventSourcingBundle\Projector;

use Insight\Component\EventSourcing\Projection;
use Insight\Component\EventSourcing\Projector;

final readonly class ProjectorWorker
{
    /**
     * @param iterable<int, Projection> $projections
     */
    public function __construct(private Projector $projector, private iterable $projections)
    {
    }

    public function start(): void
    {
        $this->projector->run(...$this->projections);
    }
}
    