<?php

use Insight\Bundle\EventSourcingBundle\Extension\StoreExtension;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;

return function(ContainerConfigurator $container): void
{
    $services = $container->services();

    $services
        ->defaults()
        ->autowire()
        ->autoconfigure();

    $services->load('Insight\\Bundle\\EventSourcingBundle\\Cache\\', __DIR__ . '/../src/Cache');
    $services->load('Insight\\Bundle\\EventSourcingBundle\\Command\\', __DIR__ . '/../src/Command');
    $services->load('Insight\\Bundle\\EventSourcingBundle\\Projector\\', __DIR__ . '/../src/Projector');
};
