<?php

declare(strict_types=1);

use Insight\Bundle\EventSourcingBundle\Exception\InvalidConfigurationException;
use Insight\Component\EventSourcing\EventSourceAggregate;
use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;

return static function (DefinitionConfigurator $definition): void
{
    $definition->rootNode()
        ->children()
            ->arrayNode('aggregates')
                ->defaultValue([])
                ->scalarPrototype()
                    ->validate()
                    ->always(static function (mixed $value): string {
                        if (!is_string($value) || !is_a($value, EventSourceAggregate::class, true)) {
                            throw new InvalidConfigurationException('Aggregate has to be a valid class extending EventSourceAggregate.');
                        }
                        return $value;
                    })
                ->end()
            ->end()
        ->end()
    ;
};
