<?php

declare(strict_types=1);

namespace Insight\Bundle\EventSourcingBundle\Extension\Store;

use Insight\Bundle\EventSourcingBundle\Exception\InvalidConfigurationException;
use Insight\Bundle\EventSourcingBundle\Extension\StoreExtension;
use Insight\Component\EventSourcing\Mongo\Exception\DependencyException;
use Insight\Component\EventSourcing\Mongo\MongoEventStore;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\ExpressionLanguage\Expression;

final readonly class MongoStoreExtension implements StoreExtension
{
    public function registerStore(ContainerBuilder $container, array $options): Definition
    {
        DependencyException::check();

        ['document_manager' => $documentManager] = $this->validateOptions($options);

        $expression = new Expression(
            sprintf('service("doctrine_mongodb").getManager("%s")', $documentManager),
        );

        return new Definition(MongoEventStore::class, [$expression]);
    }

    public function type(): string
    {
        return 'mongodb';
    }

    /**
     * @param mixed[] $options
     *
     * @return array{
     *     document_manager: string
     * }
     */
    private function validateOptions(array $options): array
    {
        $manager = $options['document_manager'] ?? null;

        if (!is_string($manager) || strlen($manager) === 0) {
            throw new InvalidConfigurationException('Document manager must be set for MongoDB event store');
        }

        return [
            'document_manager' => $manager,
        ];
    }
}
