<?php

/*
 * Use this constant as a placeholder in situations where value may not be defined at all and NULL is not enough.
 */
const UNDEFINED = new Undefined();

/**
 * @phpstan-assert-if-true Undefined $value
 */
function is_undefined(mixed $value): bool {
    return $value === UNDEFINED;
}

final readonly class Undefined
{
    public function __construct()
    {
        defined('UNDEFINED') && throw new LogicException('You should not instantiate this class and use UNDEFINED constant instead.');
    }
}
