<?php

declare(strict_types=1);

namespace Tests\DawidRza\Component\Persistence\_Type;

use DawidRza\Component\Persistence\MongoDB\MongoRepository;

/**
 * @template-extends MongoRepository<ExampleDocument>
 */
final class ExampleRepository extends MongoRepository
{
    protected static function getDocumentClassName(): string
    {
        return ExampleDocument::class;
    }

    /**
     * @param non-empty-string $documentId
     */
    final public function _findDocumentById(string $documentId): ?ExampleDocument
    {
        return $this->findDocumentById($documentId);
    }

    /**
     * @param ExampleDocument $document
     */
    final public function _scheduleDocumentForRemove(object $document): void
    {
        $this->scheduleDocumentForRemove($document);
    }

    /**
     * @param ExampleDocument $document
     */
    final public function _scheduleDocumentForUpsert(object $document): void
    {
        $this->scheduleDocumentForUpsert($document);
    }
}
