<?php

declare(strict_types=1);

namespace DawidRza\Component\Persistence;

/**
 * @template TEvent of object
 */
trait WithEvents
{
    /** @var list<TEvent> $events */
    private array $events = [];

    /**
     * @param TEvent $event
     * @param TEvent ...$events
     */
    private function record(object $event, object... $events): void
    {
        array_push($this->events, $event, ...$events);
    }
}
