<?php

declare(strict_types=1);

namespace DawidRza\Component\Persistence;

/**
 * @template TEvent of object
 */
interface EventPublisher
{
    /**
     * The persistence library will provide the events previously recorded by
     * the application using WithEvents trait and apply this method to all of them.
     *
     * @param TEvent ...$events
     */
    public function publish(object ...$events): void;
}
