<?php

declare(strict_types=1);

namespace DawidRza\Component\Persistence\MongoDB;

use Doctrine\ODM\MongoDB\Aggregation\Builder;
use InvalidArgumentException;
use LogicException;

class AggregationBuilder extends Builder
{
    private bool $hasResultType = false;

    /**
     * Allows to set hydration class only once. Subsequent calls will result in fatal error.
     *
     * {@inheritDoc}
     */
    public function hydrate(?string $className): static
    {
        if ($this->hasResultType) {
            throw new LogicException('Attempted to reset hydration class.');
        }

        if ($className === null) {
            throw new InvalidArgumentException('Hydration class must be a valid class string.');
        }

        $this->hasResultType = true;

        return parent::hydrate($className);
    }
}
