<?php

declare(strict_types=1);

namespace Tests\DawidRza\Component\Persistence;

use DawidRza\Component\Persistence\MongoDB\MongoUOW;
use Doctrine\ODM\MongoDB\Configuration;
use Doctrine\ODM\MongoDB\DocumentManager;
use Doctrine\ODM\MongoDB\Mapping\Driver\AttributeDriver;
use MongoDB\Client;
use PHPUnit\Framework\Attributes\BeforeClass;
use PHPUnit\Framework\TestCase;
use Tests\DawidRza\Component\Persistence\_Type\ExampleRepository;

abstract class BasicTestCase extends TestCase
{
    private static MongoUOW $unitOfWork;

    #[BeforeClass]
    final public static function setupUnitOfWork(): void
    {
        if (isset(self::$unitOfWork)) {
            return;
        }

        $configuration = new Configuration();
        $configuration->setProxyDir(sys_get_temp_dir() . '/tests/proxy');
        $configuration->setProxyNamespace('Tests\Proxy');
        $configuration->setHydratorDir(sys_get_temp_dir() . '/tests/hydrator');
        $configuration->setHydratorNamespace('Tests\Hydrator');
        $configuration->setMetadataDriverImpl(AttributeDriver::create());

        $documentManager = DocumentManager::create(
            client: new Client('mongodb://mongodb:27017'),
            config: $configuration,
        );

        self::$unitOfWork = new MongoUOW($documentManager);
    }

    final protected static function getUnitOfWork(): MongoUOW
    {
        return self::$unitOfWork;
    }

    final protected static function getRepository(): ExampleRepository
    {
        return new ExampleRepository(self::getUnitOfWork());
    }
}
