<?php

declare(strict_types=1);

namespace Tests\DawidRza\Component\Persistence\_Type;

use Doctrine\ODM\MongoDB\Mapping\Annotations\Document;
use Doctrine\ODM\MongoDB\Mapping\Annotations\Field;
use Doctrine\ODM\MongoDB\Mapping\Annotations\Id;

#[Document(db: 'test', collection: 'documents')]
class ExampleDocument
{
    public function __construct(
        #[Id(name: 'id', type: 'string', strategy: 'NONE')]
        public string $id,

        #[Field(name: 'name', type: 'string')]
        public string $name,
    ) {
    }

    public function changeName(string $name): void
    {
        $this->name = $name;
    }
}
