<?php

declare(strict_types=1);

namespace DawidRza\Component\Persistence\MongoDB\Exception;

use LogicException;
use Throwable;

final class MappingException extends LogicException
{
    public static function documentIsNotReadOnly(string $documentClassName): self
    {
        return new self(
            message: "Document must be set as read-only: $documentClassName",
        );
    }

    public static function documentIsNotSet(string $documentClassName, ?Throwable $previous = null): self
    {
        return new self(
            message: "Document class is either not set or not properly mapped: $documentClassName",
            previous: $previous,
        );
    }
}
