<?php

declare(strict_types=1);

namespace DawidRza\Component\Persistence\MongoDB;

use DawidRza\Component\Persistence\UnitOfWork;
use Doctrine\ODM\MongoDB\DocumentManager;
use Doctrine\ODM\MongoDB\MongoDBException;
use Throwable;

final readonly class MongoUOW implements UnitOfWork
{
    /**
     * @internal Only for internal use, not part of the public API.
     */
    public DocumentManager $documentManager;

    public function __construct(DocumentManager $documentManager)
    {
        $this->documentManager = $documentManager;
    }

    /**
     * @throws MongoDBException
     * @throws Throwable
     */
    public function applyChanges(): void
    {
        $this->documentManager->flush();
    }

    public function clear(): void
    {
        $this->documentManager->clear();
    }

    /**
     * @internal
     */
    public function getDocumentManager(): DocumentManager
    {
        return $this->documentManager;
    }
}
