<?php

declare(strict_types=1);

namespace DawidRza\Component\Persistence\MongoDB\Exception;

use LogicException;
use Throwable;

final class MappingException extends LogicException
{
    public function __construct(string $documentClassName, Throwable $exception)
    {
        parent::__construct(
            message: "Document class is either not set or not properly mapped: $documentClassName",
            previous: $exception,
        );
    }
}
