<?php

declare(strict_types=1);

namespace DawidRza\Bridge\Nexus;

use DateTimeImmutable;

final readonly class Envelope
{
    /**
     * @param array<mixed> $payload
     * @param array<mixed> $headers
     */
    public function __construct(
        public string $id,
        public string $service,
        public string $type,
        public int $time,
        public array $payload,
        public array $headers,
    ) {
    }

    public function dateTime(): DateTimeImmutable
    {
        return DateTimeImmutable::createFromTimestamp($this->time / 1000);
    }
}
