<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony;

use DawidRza\Component\Http\Validator\Validator;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final readonly class SymfonyValidator implements Validator
{
    public function __construct(private ValidatorInterface $validator)
    {
    }

    public function validate(object $object): void
    {
        $violations = $this->validator->validate($object);

        if ($violations->count() > 0) {
            throw new \Exception('VALIDATION ERROR');
        }
    }
}
