<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\EventListener;

use DawidRza\Component\Http\Context;
use DawidRza\Component\Http\Response;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\HttpFoundation\Response as SymfonyResponse;
use Symfony\Component\HttpKernel\Event\ViewEvent;

#[AsEventListener(priority: 1024)]
final readonly class OnView
{
    public function __invoke(ViewEvent $event): void
    {
        $request = $event->getRequest();

        $event->setResponse(
            $this->writeSymfonyResponse(
                $request->attributes->get(Context::class)->response(),
            ),
        );
    }

    /**
     */
    private function writeSymfonyResponse(Response $response): SymfonyResponse
    {
        $symfonyResponse = new SymfonyResponse(
            content: $response->content,
            status: $response->code->value,
            headers: $response->headers,
        );

        foreach ($response->cookies as $cookie) {
            $symfonyResponse->headers->setCookie(
                new Cookie(
                    name: $cookie->name,
                    value: $cookie->value,
                    expire: $cookie->expiresAt ?? 0,
                    path: $cookie->path,
                    secure: $cookie->secure,
                    samesite: $cookie->sameSite,
                    httponly: $cookie->httpOnly,
                ),
            );
        }

        return $symfonyResponse;
    }
}
