#!/usr/bin/env sh

DEPLOYMENT="deployment/satis"

if ! _=$(kubectl get $DEPLOYMENT 2>&1 >/dev/null); then
    echo "Error: K8 deployment unavailable"
    exit 1
fi

if ! _=$(jq --version 2>&1 >/dev/null); then
    echo "Error: jq unavailable"
    exit 1
fi

GetVersion() {
    composer show --self --format=json | jq -r '.versions[0]'
}

Publish() {
    VERSION="v$(GetVersion)"

    if ! git tag "$VERSION"; then
        exit 1
    fi

    git push --tags

    POD=$(kubectl get pods --selector=app=satis --output jsonpath="{.items[0].metadata.name}")

    kubectl exec "$POD" -- sh -c "su - satis -c 'cd /satis; bin/satis build'" >/dev/null 2>&1

    echo "PUBLISHED: $VERSION"
}

Publish
