<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Metadata;

use Psr\Cache\CacheItemPoolInterface;

final readonly class ClassMetadataRegistry
{
    public function __construct(
        private ?CacheItemPoolInterface $cache = null,
    ) {
    }

    public function get(string $class): ClassMetadata
    {
        if (null === $this->cache) {
            return ClassMetadata::parse($class);
        }

        /** @noinspection PhpUnhandledExceptionInspection */
        $cacheItem = $this->cache->getItem(str_replace("\\", "_", $class));

        if ($cacheItem->isHit()) {
            return $cacheItem->get();
        }

        $cacheItem->set($value = ClassMetadata::parse($class));

        $this->cache->save($cacheItem);

        return $value;
    }
}
