<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\EventListener;

use DawidRza\Component\Http\Context;
use DawidRza\Component\Http\ContextBinder;
use DawidRza\Component\Http\Symfony\SymfonyContext;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\RequestEvent;

#[AsEventListener]
final readonly class OnRequest
{
    public function __construct(private ContextBinder $contextBinder)
    {
    }

    public function __invoke(RequestEvent $event): void
    {
        $request = $event->getRequest();

        $request->attributes->set(Context::class, new SymfonyContext($this->contextBinder, $request));
    }
}
