<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\DependencyInjection;

use DawidRza\Component\Http\ContextBinder;
use DawidRza\Component\Http\Symfony\EventListener\OnRequest;
use DawidRza\Component\Http\Symfony\EventListener\OnView;
use DawidRza\Component\Http\Symfony\SymfonyValidator;
use DawidRza\Component\Http\Symfony\ValueResolver\ContextValueResolver;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\AbstractExtension;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class SymfonyContextExtension extends AbstractExtension
{
    public function __construct(
        private readonly bool $useResponse = true,
        private readonly bool $useResolver = true,
    ) {
    }

    /**
     * {@inheritDoc}
     */
    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $services = $container->services();

        $services
            ->defaults()
            ->autoconfigure()
            ->autowire();

        $this->registerContextBinder($container, $builder);

        $services->set(OnRequest::class);

        if ($this->useResponse) {
            $services->set(OnView::class);
        }

        if ($this->useResolver) {
            $services->set(ContextValueResolver::class);
        }
    }

    private function registerContextBinder(ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $service = $container
            ->services()
            ->set(ContextBinder::class)
            ->arg('$classMetadata', null)
            ->arg('$validator', null);

        if ($builder->has(ValidatorInterface::class)) {
            $container
                ->services()
                ->set(SymfonyValidator::class);

            $service
                ->arg('$validator', new Reference(SymfonyValidator::class));
        }
    }
}
