<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony;

use DawidRza\Component\Http\ContextBinder;
use Symfony\Component\HttpFoundation\Request;
use WeakMap;

final class SymfonyContextStorage
{
    private WeakMap $storage;

    public function __construct(private readonly ContextBinder $contextBinder)
    {
        $this->clear();
    }

    public function clear(): void
    {
        $this->storage = new WeakMap();
    }

    public function for(Request $request): SymfonyContext
    {
        return $this->storage[$request] ??= new SymfonyContext($this->contextBinder, $request);
    }
}
