<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony;

use DawidRza\Component\Http\ContextBinder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use WeakMap;

final class SymfonyContextRegistry
{
    private WeakMap $registry;

    public function __construct(
        private readonly ContextBinder $binder,
        private readonly ValidatorInterface|null $validator,
    ) {
        $this->registry = new WeakMap();
    }

    public function for(Request $request): SymfonyContext
    {
        return $this->registry[$request] ??= new SymfonyContext();
    }
}
