<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\EventListener;

use DawidRza\Component\Http\Response;
use DawidRza\Component\Http\Symfony\SymfonyContextStorage;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpFoundation\Response as SymfonyResponse;
use Symfony\Component\HttpKernel\Event\ViewEvent;

#[AsEventListener(priority: 0)]
final readonly class ControllerResponseListener
{
    public function __construct(private SymfonyContextStorage $contexts)
    {
    }

    public function __invoke(ViewEvent $event): void
    {
        $response = $this->contexts->for($event->getRequest())->response();

        $event->setResponse(
            $this->transformResponse($response),
        );
    }

    private function transformResponse(Response $response): SymfonyResponse
    {
        return new SymfonyResponse(
            content: $response->content,
            status: $response->code->value,
            headers: $response->headers,
        );
    }
}
