#!/usr/bin/env sh

DEPLOYMENT="deployment/satis"

if ! kubectl get $DEPLOYMENT > /dev/null; then
    echo ""
    exit 1
fi

GetVersion() {
    composer show --self --format=json | jq -r '.versions[0]'
#    docker compose run --rm php bash -c "composer show --self --format=json | jq -r '.versions[0]'";
}

Publish() {
    VERSION="v$(GetVersion)"

    if ! git tag "$VERSION"; then
        exit 1
    fi

    git push --tags

    POD=$(kubectl get pods --selector=app=satis --output jsonpath="{.items[0].metadata.name}")

    kubectl exec "$POD" -- sh -c "su - satis -c 'cd /satis; bin/satis build'" >/dev/null 2>&1

    echo "PUBLISHED: $VERSION"
}

Publish
