<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\ValueResolver;

use DawidRza\Component\Http\Context;
use DawidRza\Component\Http\Symfony\SymfonyContextStorage;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;

final readonly class ContextValueResolver implements ValueResolverInterface
{
    public function __construct(private SymfonyContextStorage $contextStorage)
    {
    }

    public function resolve(Request $request, ArgumentMetadata $argument): iterable
    {
        if ($argument->getType() !== Context::class) {
            return [];
        }

        return [$this->contextStorage->for($request)];
    }
}
