<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\EventListener;

use DawidRza\Component\Http\Symfony\SymfonyContextStorage;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\TerminateEvent;

#[AsEventListener(priority: 0)]
final readonly class TerminateListener
{
    public function __construct(
        private SymfonyContextStorage $contextStorage,
    ) {
    }

    public function __invoke(TerminateEvent $event): void
    {
        $this->contextStorage->clear();
    }
}
