<?php

declare(strict_types=1);

namespace DawidRza\Component\Http;

use InvalidArgumentException;

final class Response
{
    /**
     */
    private(set) Status $code = Status::OK;

    /**
     */
    private(set) ?string $content = null;

    /**
     * @var array<string, string[]>
     */
    private(set) array $headers = [];

    /**
     */
    public function content(?string $content): self
    {
        $this->content = $content;

        return $this;
    }

    /**
     */
    public function header(string $name, string $value): self
    {
        $this->headers[$name][] = $value;

        return $this;
    }

    /**
     */
    public function json(mixed $data): self
    {
        $content = json_encode($data);

        if ($content === false) {
            throw new InvalidArgumentException();
        }

        return $this->header('Content-Type', 'application/json')->content($content);
    }

    /**
     */
    public function code(Status $statusCode): self
    {
        $this->code = $statusCode;

        return $this;
    }
}
