<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\DependencyInjection;

use DawidRza\Component\Http\ContextBinder;
use DawidRza\Component\Http\Symfony\EventListener\ControllerResponseListener;
use DawidRza\Component\Http\Symfony\EventListener\TerminateListener;
use DawidRza\Component\Http\Symfony\SymfonyContextStorage;
use DawidRza\Component\Http\Symfony\SymfonyValidator;
use DawidRza\Component\Http\Symfony\ValueResolver\ContextValueResolver;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\AbstractExtension;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class SymfonyContextExtension extends AbstractExtension
{
    public function __construct(
        private readonly bool $useResponseListener = true,
        private readonly bool $useValueResolver = true,
    ) {
    }

    /**
     * {@inheritDoc}
     */
    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $services = $container->services();

        $services
            ->defaults()
            ->autoconfigure()
            ->autowire();

        $this->registerContextBinder($container, $builder);

        if ($this->useResponseListener) {
            $services->set(ControllerResponseListener::class);
        }

        if ($this->useValueResolver) {
            $services->set(SymfonyContextStorage::class);
            $services->set(ContextValueResolver::class);
            $services->set(TerminateListener::class);
        }
    }

    private function registerContextBinder(ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $service = $container
            ->services()
            ->set(ContextBinder::class)
            ->arg('$classMetadata', null)
            ->arg('$validator', null);

        if ($builder->has(ValidatorInterface::class)) {
            $container
                ->services()
                ->set(SymfonyValidator::class);

            $service
                ->arg('$validator', new Reference(SymfonyValidator::class));
        }
    }
}
