<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony;

use DawidRza\Component\Http\Response;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\HttpFoundation\Response as BaseSymfonyResponse;

final class SymfonyResponse extends BaseSymfonyResponse
{
    public function __construct(Response $response)
    {
        parent::__construct(
            content: $response->content,
            status: $response->code->value,
            headers: $response->headers,
        );

        foreach ($response->cookies as $cookie) {
            $this->headers->setCookie(
                new Cookie(
                    name: $cookie->name,
                    value: $cookie->value,
                    expire: $cookie->expiresAt ?? 0,
                    path: $cookie->path,
                    secure: $cookie->secure,
                    httpOnly: $cookie->httpOnly,
                    sameSite: $cookie->sameSite,
                ),
            );
        }
    }
}
