<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Exception;

use RuntimeException;
use Throwable;

final class UnexpectedErrorException extends RuntimeException
{
    private const string MESSAGE = 'An error occurred that should not happen. Make sure to clear the cache after recent changes.';

    public function __construct(Throwable $error)
    {
        parent::__construct(message: self::MESSAGE, previous: $error);
    }
}
