<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Exception;

use DawidRza\Component\Http\Metadata\ClassMetadata;
use DawidRza\Component\Http\Metadata\PropertyMetadata;
use Exception;
use Throwable;

final class BindException extends Exception
{
    /**
     */
    public readonly BindError $error;

    /**
     */
    public readonly ClassMetadata $class;

    /**
     */
    public readonly PropertyMetadata $field;

    public function __construct(
        BindError $error,
        ClassMetadata $class,
        PropertyMetadata $field,
        ?Throwable $reason = null,
    ) {
        $this->class = $class;
        $this->error = $error;
        $this->field = $field;

        parent::__construct(message: $error->name, previous: $reason);
    }

    /**
     * Returns TRUE if this exception matches the error type.
     */
    public function is(BindError $error): bool
    {
        return $this->error === $error;
    }
}
