<?php

declare(strict_types=1);

namespace DawidRza\Component\Http;

use DateTimeImmutable;

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Set-Cookie
 */
final readonly class Cookie
{
    public function __construct(
        public string $name,
        public string $value,
        public ?DateTimeImmutable $expiresAt = null,
        public ?string $domain = null,
        public ?string $path = null,
        public ?string $sameSite = null,
        public bool $secure = false,
        public bool $httpOnly = false,
    ) {
    }
}
