<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\ValueResolver;

use DawidRza\Component\Http\Context;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;

final readonly class ContextValueResolver implements ValueResolverInterface
{
    public function resolve(Request $request, ArgumentMetadata $argument): iterable
    {
        if ($argument->getType() !== Context::class) {
            return [];
        }

        return [
            $request->attributes->get(Context::class),
        ];
    }
}
