<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony;

use DawidRza\Component\Http\Exception\ValidationException;
use DawidRza\Component\Http\Validator\Validator;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final readonly class SymfonyValidator implements Validator
{
    public function __construct(private ValidatorInterface $validator)
    {
    }

    public function validate(object $object): void
    {
        $violations = $this->validator->validate($object);
        if ($violations->count() === 0) {
            return;
        }

        $errors = [];
        foreach ($violations as $violation) {
            $this->assignMessageViaPath($errors, $violation->getPropertyPath(), $violation->getMessage());
        }

        throw new ValidationException(
            message: 'VALIDATION_ERROR',
            errors: $errors,
        );
    }

    private function assignMessageViaPath(array &$errors, string $path, string $message): void
    {
        foreach (explode('.', $path) as $key) {
            $matches = [];
            if (preg_match('/^(.*)\[(\d+)]$/', $key, $matches) === 1) {
                $errors = &$errors[$matches[1]][(int) $matches[2]];
            } else {
                $errors = &$errors[$key];
            }
        }

        $errors = $message;
    }
}
