<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Symfony\EventListener;

use DawidRza\Component\Http\Context;
use DawidRza\Component\Http\Symfony\SymfonyResponse;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\ViewEvent;

#[AsEventListener(priority: 1024)]
final readonly class OnView
{
    public function __invoke(ViewEvent $event): void
    {
        $request = $event->getRequest();

        $event->setResponse(
            new SymfonyResponse(
                $request->attributes->get(Context::class)->response()
            ),
        );
    }
}
