<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Metadata\Attribute;

use Attribute;
use DawidRza\Component\Http\Exception\DefinitionException;
use ReflectionClass;

#[Attribute(Attribute::TARGET_PARAMETER | Attribute::TARGET_PROPERTY)]
final readonly class Bind
{
    public const string FORM = 'form';
    public const string FILE = 'file';
    public const string HEADER = 'header';
    public const string JSON = 'json';
    public const string PATH = 'path';
    public const string QUERY = 'query';

    public function __construct(public string $from, public string $name, public ?string $type = null)
    {
        $this->assertFrom($from);
    }

    private function assertFrom(string $from): void
    {
        static $sources = array_values(
            new ReflectionClass(self::class)->getConstants(),
        );

        if (!in_array($from, $sources)) {
            throw new DefinitionException("Unsupported property value source: $from");
        }
    }
}
