<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Json;

/**
 * @internal
 */
final class HydratorRegistry
{
    private HydratorGenerator $generator;

    private array $hydrators;

    public function __construct(?string $cacheDir = null)
    {
        $this->generator = new HydratorGenerator($this, $cacheDir ?? sys_get_temp_dir());
        $this->hydrators = [];
    }

    /**
     * @template T of object
     *
     * @param class-string<T> $class
     *
     * @return Hydrator<T>
     */
    public function get(string $class): Hydrator
    {
        return $this->hydrators[$class] ??= $this->generator->create($class); // @phpstan-ignore return.type
    }
}
