<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Exception;

use Exception;

/**
 * @phpstan-type ErrorList array<string, string>
 */
final class JsonException extends Exception
{
    public const int E_UNSUPPORTED_CONTENT = 1;
    public const int E_SYNTAX = 2;
    public const int E_FORMAT = 3;

    /**
     * @var ErrorList
     */
    private readonly array $errors;

    /**
     * @param ErrorList $errors
     */
    private function __construct(string $message, array $errors, int $code)
    {
        parent::__construct($message, $code);

        $this->errors = $errors;
    }

    public static function contentType(): self
    {
        return new self('JSON message not found', [], self::E_UNSUPPORTED_CONTENT);
    }

    public static function format(array $errors): self
    {
        return new self('JSON message format is not acceptable', $errors, self::E_FORMAT);
    }

    public static function syntax(): self
    {
        return new self('JSON message syntax is invalid', [], self::E_SYNTAX);
    }

    /**
     * @return ErrorList
     */
    public function getErrors(): array
    {
        return $this->errors;
    }
}
