#!/usr/bin/env sh

DEPLOYMENT="deployment/satis"

if ! _=$(kubectl get $DEPLOYMENT 2>&1 >/dev/null); then
    echo "Error: K8 deployment unavailable"
    exit 1
fi

if ! _=$(jq --version 2>&1 >/dev/null); then
    echo "Error: jq unavailable"
    exit 1
fi

GetVersion() {
    composer show --self --format=json | jq -r '.versions[0]'
}

Publish() {
    VERSION="v$(GetVersion)"

    if ! CreateTag "$VERSION"; then
        if ! YesNo "Tag already exists. Do you want to overwrite it?"; then
            exit 0
        fi

        if ! RemoveTag "$VERSION"; then
            exit 1
        fi
    fi

    if ! CreateTag "$VERSION"; then
        exit 1
    fi

    git push --tags

    POD=$(kubectl get pods --selector=app=satis --output jsonpath="{.items[0].metadata.name}")

    kubectl exec "$POD" -- sh -c "su - satis -c 'cd /satis; bin/satis build'" >/dev/null 2>&1

    echo "PUBLISHED: $VERSION"
}

CreateTag() {
    TAG="$1"

    git tag "$VERSION" >/dev/null 2>&1
}

RemoveTag() {
    TAG="$1"

    # REMOTE
    git push --delete origin "$TAG" >/dev/null 2>&1

    # LOCAL
    git tag -d "$TAG" >/dev/null 2>&1
}

YesNo() {
    prompt="$1"

    printf "%s [y/N]: " "$prompt"

    read answer

    case "$answer" in
        y|Y) return 0 ;;
    esac

    return 1
}

Publish
