<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Json;

use DawidRza\Component\Http\Exception\JsonException;

final readonly class JsonMapper
{
    public function __construct(
        private HydratorRegistry $hydrators,
    ) {
    }

    /**
     * @template T of object
     *
     * @param class-string<T> $type
     *
     * @return T
     * @throws JsonException
     */
    public function fromJson(string $json, string $type): object
    {
        $data = json_decode($json, true);

        if ($data === null) {
            throw JsonException::syntax();
        }

        return $this->fromJsonArray($data, $type);
    }

    /**
     * @template T of object
     *
     * @param class-string<T> $type
     *
     * @return T
     * @throws JsonException
     */
    public function fromJsonArray(array $source, string $type): object
    {
        return $this->hydrators->get($type)->hydrate($source);
    }
}

