<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Exception;

use Exception;

final class ValidationException extends Exception
{
    /**
     * @param array<string, mixed> $errors
     */
    public function __construct(string $message, private array $errors) {
        parent::__construct($message);
    }

    /**
     * @return array<string, mixed>
     */
    public function getErrors(): array
    {
        return $this->errors;
    }
}
