<?php

declare(strict_types=1);

namespace DawidRza\Component\Http;

use InvalidArgumentException;

final class Response
{
    /**
     */
    private(set) Status $code = Status::OK;

    /**
     */
    private(set) ?string $content = null;

    /**
     * @var list<Cookie>
     */
    private(set) array $cookies = [];

    /**
     * @var array<string, string[]>
     */
    private(set) array $headers = [];

    /**
     */
    public function code(Status $statusCode): self
    {
        $this->code = $statusCode;

        return $this;
    }

    /**
     */
    public function cookie(Cookie $cookie): self
    {
        $this->cookies[] = $cookie;

        return $this;
    }

    /**
     */
    public function content(?string $content): self
    {
        $this->content = $content;

        return $this;
    }

    /**
     */
    public function header(string $name, string $value): self
    {
        $this->headers[$name][] = $value;

        return $this;
    }

    /**
     */
    public function json(mixed $data): self
    {
        if (is_string($data)) {
            $content = $data;
        } else {
            $content = json_encode($data);

            if ($content === false) {
                throw new InvalidArgumentException();
            }
        }

        return $this->header('Content-Type', 'application/json')->content($content);
    }
}
