<?php

declare(strict_types=1);

namespace DawidRza\Component\Http\Metadata;

use DawidRza\Component\Http\ContentType;
use DawidRza\Component\Http\Metadata\Attribute\Bind;

final readonly class PropertyMetadata
{
    /**
     * @param array<string, Bind> $vars
     * @param array<string, Bind> $body
     */
    public function __construct(
        public string $name,
        public PropertyType $type,
        public array $vars,
        public array $body,
    ) {
    }

    /**
     * @return array<string, Bind>
     */
    public function bindsByContentType(?ContentType $type): array
    {
        if (null === $type) {
            return $this->vars;
        }

        $bind = $this->body[$type->value] ?? null;
        $vars = $this->vars;

        if (null !== $bind) {
            $vars[$type->value] = $bind;
        }

        return $vars;
    }
}
